#include "stdafx.h"
#include "Socket.h"

//////////////////////////////////////////////////////////////////////
// CSockAddr NX
//////////////////////////////////////////////////////////////////////

//
// O		:CSockAddr::CSockAddr()
// @\		:ftHgRXgN^
// 		:
// ߂l	:
//
CSockAddr::CSockAddr()
{
	memset( (void*)&m_InetSockAddr, 0, sizeof( struct sockaddr_in ) );
}

//
// O		:CSockAddr::CSockAddr( const char *IpAddr, const int nPort )
// @\		:tRXgN^
// 		:
// ߂l	:
// 
CSockAddr::CSockAddr( const char *IpAddr, const int nPort )
{
	this->m_InetSockAddr.sin_addr.s_addr = inet_addr( IpAddr );
	this->m_InetSockAddr.sin_port = htons( (u_short)nPort );
	this->m_InetSockAddr.sin_family = AF_INET;
}

//
// O		:CSockAddr::CSockAddr( const CSockAddr &Addr )
// @\		:tRXgN^
// 		:Ȃ
// ߂l	:Ȃ
// 
CSockAddr::CSockAddr( const CSockAddr &Addr )
{
	m_InetSockAddr = Addr.m_InetSockAddr;
}

//
// O		:CSockAddr::~CSockAddr()
// @\		:fXgN^
// 		:Ȃ
// ߂l	:Ȃ
//
CSockAddr::~CSockAddr()
{

}

//
// O		:CSockAddr& CSockAddr::operator = ( const CSockAddr &Addr )
// @\		:Zq
// 		:
// ߂l	:
//
CSockAddr& CSockAddr::operator = ( const CSockAddr &Addr )
{
	if( this == &Addr ){ return *this; }

	m_InetSockAddr = Addr.m_InetSockAddr;
	
	return *this;
}

//
// O		:void CSockAddr::Set( const char *IpAddr, const int nPort )
// @\		:IPAhXƃ|[gԍZbg
// 		:IpAddr - IPAhX
//			:nPort - |[gԍ
// ߂l	:Ȃ
//
void CSockAddr::Set( const char *IpAddr, const int nPort )
{
	this->m_InetSockAddr.sin_addr.s_addr = inet_addr( IpAddr );
	this->m_InetSockAddr.sin_port = htons( (u_short)nPort );
	this->m_InetSockAddr.sin_family = AF_INET;
}

//
// O		:int CSockAddr::GetPort() const
// @\		:ZbgĂ|[gԍԂ
// 		:Ȃ
// ߂l	:|[gԍ
//
int CSockAddr::GetPort() const
{
	return (int)ntohs( m_InetSockAddr.sin_port );
}

//
// O		:const char* CSockAddr::GetIpAddr() const
// @\		:ZbgĂIPAhXԂ
// 		:Ȃ
// ߂l	:IPAhX\zւ̃|C^
//
const char* CSockAddr::GetIpAddr() const
{
	return inet_ntoa( m_InetSockAddr.sin_addr );
}

//
// O		:const struct sockaddr* CSockAddr::GetSockaddr() const
// @\		:osockaddr_in\̂̃|C^sockaddr^ɃLXgĕԂ
// 		:Ȃ
// ߂l	:õ|C^
//
const struct sockaddr* CSockAddr::GetSockaddr() const
{
	return (struct sockaddr*)&m_InetSockAddr;
}

//
// O		:const struct sockaddr* CSockAddr::GetSockaddr() const
// @\		:osockaddr_in\̂̃|C^Ԃ
// 		:Ȃ
// ߂l	:õ|C^
//
const struct sockaddr_in* CSockAddr::GetSockaddrIN() const
{
	return &m_InetSockAddr;
}


//////////////////////////////////////////////////////////////////////
// CSockAddr NX
//////////////////////////////////////////////////////////////////////

//
// O		:CMMIModuleAddr::CMMIModuleAddr()
// @\		:ftHgRXgN^
// 		:Ȃ
// ߂l	:Ȃ
//
CMMIModuleAddr::CMMIModuleAddr()
{

}

//
// O		:CMMIModuleAddr::CMMIModuleAddr()
// @\		:tRXgN^
// 		:Ȃ
// ߂l	:Ȃ
//
CMMIModuleAddr::CMMIModuleAddr( const char *szName, const char *IpAddr, const int nPort )
{
	strcpy( m_szModule, szName );
	this->m_InetSockAddr.sin_addr.s_addr = inet_addr( IpAddr );
	this->m_InetSockAddr.sin_port = htons( (u_short)nPort );
	this->m_InetSockAddr.sin_family = AF_INET;
}

//
// O		:CMMIModuleAddr::CMMIModuleAddr( const CMMIModuleAddr &Addr )
// @\		:tRXgN^
// 		:Ȃ
// ߂l	:Ȃ
//
CMMIModuleAddr::CMMIModuleAddr( const CMMIModuleAddr &Addr )
{
	strcpy( m_szModule, Addr.m_szModule );
	m_InetSockAddr = Addr.m_InetSockAddr;
}

//
// O		:CMMIModuleAddr::~CMMIModuleAddr()
// @\		:fXgN^
// 		:Ȃ
// ߂l	:Ȃ
//
CMMIModuleAddr::~CMMIModuleAddr()
{

}

//
// O		:CMMIModuleAddr& CMMIModuleAddr::operator = ( const CMMIModuleAddr &Addr )
// @\		:Zq
// 		:Ȃ
// ߂l	:Ȃ
//
CMMIModuleAddr& CMMIModuleAddr::operator = ( const CMMIModuleAddr &Addr )
{
	if( &Addr == this ) { return *this; }

	strcpy( m_szModule, Addr.m_szModule );
	m_InetSockAddr = Addr.m_InetSockAddr;

	return *this;
}

//
// O		:void CMMIModuleAddr::Set( const char *Module, const char *IpAddr, const int nPort )
// @\		:o̒lZbg
// 		:Module - W[
//			:IpAddr - IPAhXiXXX.XXX.XXX.XXX`j
//			:nPort - |[gԍ
// ߂l	:Ȃ
//
void CMMIModuleAddr::Set( const char *Module, const char *IpAddr, const int nPort )
{
	strcpy( m_szModule, Module );
	this->m_InetSockAddr.sin_addr.s_addr = inet_addr( IpAddr );
	this->m_InetSockAddr.sin_port = htons( (u_short)nPort );
	this->m_InetSockAddr.sin_family = AF_INET;
}

//
// O		:const char* CMMIModuleAddr::GetName() const
// @\		:W[Ԃ
// 		:Ȃ
// ߂l	:W[\zւ̃|C^
//
const char* CMMIModuleAddr::GetName() const
{
	return m_szModule;
}


//////////////////////////////////////////////////////////////////////
// CSock NX
//////////////////////////////////////////////////////////////////////

//
// O		:CSock::CSock()
// @\		:ftHgRXgN^
// 		:Ȃ
// ߂l	:Ȃ
//
CSock::CSock()
{
	m_hSocket = INVALID_SOCKET;
}

//
// O		:CSock::~CSock()
// @\		:fXgN^
// 		:Ȃ
// ߂l	:Ȃ
//
CSock::~CSock()
{

}

//
// O		:void CSock::Attach( SOCKET hSocket )
// @\		:\Pbgnh֘At
// 		:hSocket - \Pbgnh
// ߂l	:Ȃ
//
void CSock::Attach( SOCKET hSocket )
{
	m_hSocket = hSocket;
}

//
// O		:void CSock::Detach()
// @\		:õ\Pbgnh
// 		:Ȃ
// ߂l	:Ȃ
//
void CSock::Detach()
{
	if( m_hSocket != INVALID_SOCKET )
	{
		shutdown( m_hSocket, 0x02 );
		closesocket( m_hSocket );
		m_hSocket = INVALID_SOCKET;
	}
}

//
// O		:BOOL CSock::Socket( int nAddrFamily, int nSocketType, int nProtocol )
// @\		:V\Pbgnh쐬
// 		:nAddrFamily - AhXt@~
//			:nSocketType - \Pbg̎
//			:nProtocol - vgR
// ߂l	: - TRUE s - FALSE
//
BOOL CSock::Socket( int nAddrFamily, int nSocketType, int nProtocol )
{
	m_hSocket = socket( nAddrFamily, nSocketType, nProtocol );
	if( m_hSocket == INVALID_SOCKET ) { return FALSE; }
	return TRUE;
}

//
// O		:BOOL CSock::Bind( CSockAddr *addr )
// @\		:\Pbg̃AhXɃoCh
// 		:*addr - oChAhXێCX^X̃|C^
// ߂l	: - TRUE s - FALSE
//
BOOL CSock::Bind( CSockAddr *addr )
{
	if( m_hSocket == INVALID_SOCKET ) { return FALSE; }

	if( bind( m_hSocket, addr->GetSockaddr(), sizeof( sockaddr_in ) ) == SOCKET_ERROR )
		return FALSE;
	return TRUE;
}

//
// O		:BOOL CSock::Bind( CSockAddr *addr )
// @\		:\Pbg̃AhXɃoCh
// 		:*addr - oChAhXێCX^X̃|C^
// ߂l	: - TRUE s - FALSE
//
BOOL CSock::Listen( int nMaxCon )
{
	if( m_hSocket == INVALID_SOCKET ) { return FALSE; }

	if( listen( m_hSocket, nMaxCon ) == SOCKET_ERROR )
		return FALSE;
	return TRUE;
}

//
// O		:BOOL CSock::Accept( CSock &sock )
// @\		:̃\PbgŐڑṽANZvg
// 		:&sock - ANZvgp̃\Pbg
// ߂l	: - TRUE s - FALSE
//
BOOL CSock::Accept( CSock &sock )
{
	if( m_hSocket == INVALID_SOCKET ) { return FALSE; }

	int nSize = sizeof( sockaddr );
	SOCKET hSocket = accept( m_hSocket, NULL, &nSize );

	if( hSocket != INVALID_SOCKET )
	{
		sock.Attach( hSocket );
		return TRUE;
	}
	return FALSE;
}

//
// O		:BOOL CSock::Connect( CSockAddr *addr )
// @\		:̃AhXɐڑ
// 		:*addr - ڑAhXێCX^X̃|C^
// ߂l	: - TRUE s - FALSE
//
BOOL CSock::Connect( CSockAddr *addr )
{
	if( m_hSocket == INVALID_SOCKET ) { return FALSE; }

	if( connect( m_hSocket, addr->GetSockaddr(), sizeof( sockaddr_in ) ) == SOCKET_ERROR )
		return FALSE;
	return TRUE;
}

//
// O		:void CSock::Detach()
// @\		:õ\Pbgnh
// 		:
// ߂l	:
//
void CSock::Close()
{
	shutdown( m_hSocket, 0x02 );
	closesocket( m_hSocket );
	m_hSocket = INVALID_SOCKET;
}

//
// O		:int CSock::Send( LPCSTR sMsg, int nByte )
// @\		:sMsgnByteoCg
// 		:sMsg - Mobt@̃|C^
//			:nByte - oCg
// ߂l	:ۂɑꂽoCg
//
int CSock::Send( LPCSTR sMsg, size_t nByte )
{
	if( m_hSocket == INVALID_SOCKET ) { return 0; }
	return send( m_hSocket, sMsg, (unsigned int)nByte, 0 );
}

//
// O		:int CSock::Recv( LPSTR sBuff )
// @\		:MāAsBuffɊi[
// 		:sBuff - Mpobt@̃|C^
// ߂l	:MoCg
//
int CSock::Recv( LPSTR sBuff )
{
	if( m_hSocket == INVALID_SOCKET ) { return 0; }
	return recv( m_hSocket, sBuff, RECV_BUFFER_SIZE, 0 );
}

//
// O		:void CSock::Detach()
// @\		:õ\PbgnhLׂ
// 		:
// ߂l	:L - TRUE  - FALSE
//
BOOL CSock::IsValid()
{
	if( m_hSocket == INVALID_SOCKET ){ return FALSE; }
	return TRUE;
}

//////////////////////////////////////////////////////////////////////
// CComMsg NX
//////////////////////////////////////////////////////////////////////

//
// O		:CComMsg::CComMsg()
// @\		:ftHgRXgN^
// 		:Ȃ
// ߂l	:Ȃ
//
CComMsg::CComMsg()
{

}

//
// O		:CComMsg::CComMsg()
// @\		:tRXgN^
// 		:Ȃ
// ߂l	:Ȃ
//
CComMsg::CComMsg( string &msg )
{
	m_Msg = msg;
}

//
// O		:CComMsg::CComMsg()
// @\		:Rs[RXgN^
// 		:Ȃ
// ߂l	:Ȃ
//
CComMsg::CComMsg( const CComMsg &msg )
{
	m_Msg = msg.m_Msg;
}

//
// O		:CComMsg::CComMsg()
// @\		:fXgN^
// 		:Ȃ
// ߂l	:Ȃ
//
CComMsg::~CComMsg()
{

}

//
// O		:CComMsg::CComMsg()
// @\		:Zq
// 		:Ȃ
// ߂l	:Ȃ
//
CComMsg& CComMsg::operator = ( const CComMsg &msg )
{
	if( this == &msg ) return *this;

	m_Msg = msg.m_Msg;

	return *this;
}

//
// O		:void CComMsg::Set( string &msg )
// @\		:bZ[W̃Zbg
// 		:msg - bZ[W
// ߂l	:Ȃ
//
void CComMsg::Set( string &msg )
{
	m_Msg = msg;	
}

//
// O		:string CComMsg::Get()
// @\		:bZ[W擾
// 		:Ȃ
// ߂l	:bZ[W
//
string CComMsg::Get()
{
	return m_Msg;
}

//
// O		:string CComMsg::GetCmd() const
// @\		:bZ[W̃R}h擾
// 		:Ȃ
// ߂l	:R}h
//
string CComMsg::GetCmd() const
{
	return GetSubstring( "<command>" );
}

//
// O		:string CComMsg::GetFrom() const
// @\		:bZ[W<from>̒l擾
// 		:Ȃ
// ߂l	:<from>̒l
//
string CComMsg::GetFrom() const
{
	return GetSubstring( "<from>" );
}

//
// O		:const char* CComMsg::GetTo() const
// @\		:bZ[W<to>̒l擾
// 		:Ȃ
// ߂l	:<to>̒l
//
string CComMsg::GetTo() const
{
	return GetSubstring( "<to>" );
}

//
// O		:string CComMsg::GetSubstring( const char *szTag ) const
// @\		:Ŏw肳ꂽ^O̕擾
// 		:szTag - 擾^O̖O
// ߂l	:szTag^O̕
//
string CComMsg::GetSubstring( const char *szTag ) const
{
	string closer = szTag;
	closer.insert( 1, "/" );

	size_t nStart = m_Msg.find( szTag ) + strlen( szTag );
	size_t nEnd = m_Msg.find( closer, nStart );

	if( nStart == string::npos || nEnd == string::npos )
	{
		return "";
	}
	else
	{
		return m_Msg.substr( nStart, nEnd - nStart );

	}
}

void CComMsg::Dump()
{
	cout << m_Msg << endl;
}

//////////////////////////////////////////////////////////////////////
// CMsgServer NX
//////////////////////////////////////////////////////////////////////

//
// O		:CMsgServer::CMsgServer()
// @\		:RXgN^
// 		:Ȃ
// ߂l	:Ȃ
//
CMsgServer::CMsgServer()
{
	m_hWnd = NULL;
	WinSockInit();
	// ꉞNA
	m_Addrlist.clear();
	m_MsgDeque.clear();
	// AhXǂݍ
	ReadAddrFile( ADDRFILE );
	
	// ftHgbZ[WL[̃NeBJZNV
	InitializeCriticalSection( &m_CriticalSection );
}

//
// O		:CMsgServer::CMsgServer()
// @\		:fXgN^
// 		:Ȃ
// ߂l	:Ȃ
//
CMsgServer::~CMsgServer()
{
	// NeBJZNV̔j
	DeleteCriticalSection( &m_CriticalSection );

	// new čĂ̂ŕK`FbN
	if( !m_Addrlist.empty() )
	{
		ClearAddr();
	}
}

//
// O		:void CSock::WinSockInit()
// @\		:WinSock̏
// 		:Ȃ
// ߂l	:Ȃ
//
void CMsgServer::WinSockInit()
{
	// WinSock̏
	int		nResult;
	WORD	wRequireVersion;	// gpWinSock̃o[W
	WSADATA	lpWSAData;			// WinSocǩ

	// WinSock2gpWinSock̃o[WƂĐݒ
	wRequireVersion = MAKEWORD( 2, 0 );

	// WinSock̏sȂ
	nResult = WSAStartup( wRequireVersion, &lpWSAData );
	if( nResult != 0  )
	{
//		cerr << "WinSock̏Ɏs" << endl;
	}

	// WinSock̃o[Wv̂mF
	if( lpWSAData.wVersion != wRequireVersion )
	{
//		cerr << "vWinSock̃o[W擾ł܂ł" << endl;
	}
}

//
// O		:void CMsgServer::ReadAddrFile( LPCSTR szFile )
// @\		:AhXt@Cǂݍ
// 		:szFile - t@C
// ߂l	:Ȃ
//
void CMsgServer::ReadAddrFile( LPCSTR szFile )
{
	char name[RECV_BUFFER_SIZE+1];	// W[
	char ip[16];			// XXX.XXX.XXX.XXX`IP
	int port;				// |[gԍ

	// Xg̏
	m_Addrlist.clear();
	list < CMMIModuleAddr* > :: iterator ite = m_Addrlist.begin();

	// ǂݍ݃[hŃt@CJ
	fstream fs( szFile, ios::in );
	if( fs.is_open() != 0 )
	{
		// EOFԂ܂Ńt@Cǂ
		while( !fs.eof() )
		{
			fs >> name >> ip >> port;
			// ǂ񂾃f[^i[
			CMMIModuleAddr *addr = new CMMIModuleAddr( name, ip, port );
			m_Addrlist.insert( ite, addr );
		}
	}
	// t@C
	fs.close();
}

//
// O		:void CMsgServer::ClearAddr()
// @\		:AhXNA
// 		:Ȃ
// ߂l	:Ȃ
//
void CMsgServer::ClearAddr()
{
	// Ce[^̏
	list < CMMIModuleAddr* > :: iterator ite = m_Addrlist.begin();
	while( ite != m_Addrlist.end() )
	{
		// Ă
		delete (*ite);
		ite++;
	}
	// ꉞXgNA
	m_Addrlist.clear();
//	cout << "Addrlist cleared." << endl;
}

//
// O		:CMMIModuleAddr* CMsgServer::GetAddr( LPCSTR szModule )
// @\		:szModulẽAhX擾
// 		:Ȃ
// ߂l	:AhX
//
CMMIModuleAddr* CMsgServer::GetAddr( LPCSTR szModule )
{
	list < CMMIModuleAddr* > :: iterator ite = m_Addrlist.begin();
	while( ite != m_Addrlist.end() )
	{
		if( !strcmp( (*ite)->GetName(), szModule ) )
		{
			return *ite;
		}
		ite++;
	}
	return NULL;
}

//
// O		:void CMsgServer::Run()
// @\		:MpXbh̊Jn
// 		:Ȃ
// ߂l	:Ȃ
//
void CMsgServer::Run()
{
	if( m_Socket.IsValid() )
		m_dwThread = _beginthread( CMsgServer::RecvThread, 0, (LPVOID)this );	
}

//
// O		:void CMsgServer::Run()
// @\		:MpXbh̒~
// 		:Ȃ
// ߂l	:Ȃ
//
void CMsgServer::Stop()
{
	// ڑҋ@p\Pbg
	m_Socket.Close();

	// XbhI܂őҋ@
	WaitForSingleObject( (HANDLE)m_dwThread, INFINITE );

//	cout << "Thread End." << endl;
}

//
// O		:BOOL CMsgServer::Initialize( LPCSTR szModule )
// @\		:CX^X̏
// 		:szModule - W[
// ߂l	: - TRUE s - FALSE
//
BOOL CMsgServer::Initialize( LPCSTR szModule, HWND hWnd )
{
	strcpy( m_szModule, szModule );
	m_hWnd = hWnd;

	// W[玩IPAhXƃ|[gԍ߂
	CMMIModuleAddr *addr = GetAddr( szModule );
	if( addr != NULL )
	{
		// \Pbg̃oCh
		m_Socket.Socket();
		if( m_Socket.Bind( addr ) )
		{
			return TRUE;
		}
	}
//	cerr << "bind failed." << endl;

	return FALSE;
}

//
// O		:void CMsgServer::RecvThread( void *lpParam )
// @\		:MpXbh
// 		:*lpParam - gւ̃|C^
// ߂l	:Ȃ
//
void CMsgServer::RecvThread( void *lpParam )
{
//	cout << "Enter Thread." << endl;

	CMsgServer *lpServ = (CMsgServer*)lpParam;

	CSock SockCon;					// Mp\Pbg
	int nRecv;						// MTCYێ
	string sMsg;					// Mf[^i[
	char szBuff[RECV_BUFFER_SIZE];		// Mpobt@

	// bZ[WM[vɓ
	if( !lpServ->m_Socket.Listen() )
	{
//		cerr << "listen failed." << WSAGetLastError() << endl;
		_endthread();
	}

	while( 1 )
	{
			if( !lpServ->m_Socket.Accept( SockCon ) )
			{
				// ڑҋ@p̃\Pbgꂽ̂ŃXbhI
				break;
			}

			// 肪ؒf܂ŎM
			while( 1 )
			{
				nRecv = SockCon.Recv( szBuff );
				if( nRecv == 0 )
					break;
				if( nRecv != SOCKET_ERROR )
					sMsg.append( szBuff, nRecv );
			}
			
			// M
			SockCon.Close();
			
			// MbZ[WKɏ
			lpServ->AnalyzeMessage( sMsg );
			
			// Mobt@NA
			sMsg.erase();
	}

//	cout << "Exit Thread." << endl;
	_endthread();
}


//
// O		:void CMsgServer::AnalyzeMessage( string &msg )
// @\		:MbZ[WL[Ɋi[
// 		:&msg - MbZ[W
// ߂l	:Ȃ
//
void CMsgServer::AnalyzeMessage( string &msg )
{
	CComMsg *Msg = new CComMsg( msg );
	
	EnterCriticalSection( &m_CriticalSection );
	m_MsgDeque.push_back( Msg );
	LeaveCriticalSection( &m_CriticalSection );

	if( m_hWnd != NULL )
		SendMessage( m_hWnd, WM_MMIMSG_QUEUED, 0 , 0 );
}

//
// O		:BOOL CMsgServer::GetMsg( CComMsg &message )
// @\		:L[烁bZ[Wo
// 		:&message - bZ[Wi[p̃CX^X
// ߂l	: - TRUE s - FALSE
//
BOOL CMsgServer::GetMsg( CComMsg &message )
{
	if( m_MsgDeque.size() != 0 )
	{
		EnterCriticalSection( &m_CriticalSection );
		// ɃL[̃gbvRs[
		message = *m_MsgDeque.front();
		delete m_MsgDeque.front();
		m_MsgDeque.pop_front();
		LeaveCriticalSection( &m_CriticalSection );
		return TRUE;
	}
	return FALSE;
}

BOOL CMsgServer::GetMsg( string &msg )
{
	CComMsg cmsg;
	BOOL ret = GetMsg( cmsg );
	msg = cmsg.Get();
	return ret;
}

//
// O		:BOOL CMsgServer::SendMsg( CComMsg &msg )
// @\		:msg𑗐M
// 		:&msg - M郁bZ[W
// ߂l	: - TRUE s - FALSE
//
BOOL CMsgServer::SendMsg( CComMsg &msg )
{
	CSock sock;
	// M̃AhX擾
	CMMIModuleAddr *addr = GetAddr( msg.GetTo().c_str() );

	if( addr != NULL )
	{
		// ڑ
		if( sock.Socket() && sock.Connect( addr ) )
		{
			// bZ[W̃TCY𒲂ׂāASMł܂łЂsend
			size_t nSize = msg.Get().length();
			size_t nRet = 0;
			while( 1 )
			{
				if( nRet >= nSize )
					break;
				nRet += sock.Send( &(msg.Get())[nRet], nSize - nRet );
			}
			// I\Pbg
			sock.Close();
			return TRUE;
		}
	}
	return FALSE;
}

BOOL CMsgServer::SendMsg( string &msg )
{
	CComMsg cmsg( msg );
	return SendMsg( cmsg );
}

BOOL CMsgServer::SendMsg(LPCTSTR lpszMsg,LPCTSTR lpszAddrTo)
{
	CSock sock;
	// M̃AhX擾
	CMMIModuleAddr *addr = GetAddr( lpszAddrTo );

	string msg = lpszMsg;
	if( addr != NULL )
	{
		// ڑ
		if( sock.Socket() && sock.Connect( addr ) )
		{
			// bZ[W̃TCY𒲂ׂāASMł܂łЂsend
			size_t nSize = msg.length();
			size_t nRet = 0;
			while( 1 )
			{
				if( nRet >= nSize )
					break;
				nRet += sock.Send( &msg[nRet], nSize - nRet );
			}
			// I\Pbg
			sock.Close();
			return TRUE;
		}
	}
	return FALSE;
}